/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import jpcsp.HLE.modules.sceAudio;
import org.apache.log4j.Logger;
import org.lwjgl.openal.AL10;

public class SoundBufferManager {
    private static Logger log = sceAudio.log;
    private static SoundBufferManager instance;
    private Stack<Integer> freeBuffers = new Stack();
    private List<ByteBuffer> freeDirectBuffers = new LinkedList<ByteBuffer>();

    public static SoundBufferManager getInstance() {
        if (instance == null) {
            instance = new SoundBufferManager();
        }
        return instance;
    }

    private SoundBufferManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBuffer() {
        Stack<Integer> stack = this.freeBuffers;
        synchronized (stack) {
            if (this.freeBuffers.isEmpty()) {
                int alBuffer = AL10.alGenBuffers();
                this.freeBuffers.push(alBuffer);
            }
            return this.freeBuffers.pop();
        }
    }

    public void checkFreeBuffers(int alSource) {
        int alBuffer;
        while ((alBuffer = this.checkFreeBuffer(alSource)) >= 0) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkFreeBuffer(int alSource) {
        int processedBuffers = AL10.alGetSourcei((int)alSource, (int)4118);
        if (processedBuffers <= 0) {
            return -1;
        }
        int alBuffer = AL10.alSourceUnqueueBuffers((int)alSource);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("free buffer %d", alBuffer));
        }
        Stack<Integer> stack = this.freeBuffers;
        synchronized (stack) {
            this.freeBuffers.push(alBuffer);
        }
        return alBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getDirectBuffer(int size) {
        List<ByteBuffer> list = this.freeDirectBuffers;
        synchronized (list) {
            for (int i = 0; i < this.freeDirectBuffers.size(); ++i) {
                ByteBuffer directBuffer = this.freeDirectBuffers.get(i);
                if (directBuffer.capacity() < size) continue;
                this.freeDirectBuffers.remove(i);
                return directBuffer;
            }
        }
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(size);
        return directBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDirectBuffer(ByteBuffer directBuffer) {
        List<ByteBuffer> list = this.freeDirectBuffers;
        synchronized (list) {
            if (this.freeDirectBuffers.isEmpty()) {
                this.freeDirectBuffers.add(directBuffer);
            } else {
                this.freeDirectBuffers.add(0, directBuffer);
            }
        }
    }
}

